function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_corr_reserves.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(66, 1);
residual(1) = T(29)+T(32)+params(21)*y(112)-y(77);
residual(2) = T(24)*(-exp(y(23)))+y(70)*(-(T(28)*params(4)*exp(y(23)*params(4))))+exp(y(23))*y(60)+params(21)*y(114)-y(79);
residual(3) = y(69)*(-(T(27)*params(4)*exp(y(24)*params(4))))+y(65)*y(35)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1))+exp(y(24))*y(60)+params(21)*y(113)-y(78);
residual(4) = T(24)*T(33)+y(73)*(-exp(y(25)))+exp(y(25))*y(72)+params(21)*y(116)-y(81);
residual(5) = y(73)*(-exp(y(26)))+exp(y(26))*y(71)+params(21)*y(115)-y(80);
residual(6) = T(35)+params(21)*y(119)-y(84);
residual(7) = T(37)+params(21)*y(118)-y(83);
residual(8) = T(38);
residual(9) = T(39);
residual(10) = T(41)+params(21)*y(111)*(-exp(y(31)));
residual(11) = T(36)+y(66)*T(42)+y(63)*T(43)+params(21)*y(102)*exp(y(28))*params(6)*params(5)*exp(params(5)*y(32))+T(44);
residual(12) = exp(y(33))*y(59);
residual(13) = y(64)*(-params(7))+y(63)+T(30)*y(18)*(-(exp(y(43))*(1-exp(y(11)))))+T(30)*exp(y(43))*y(20);
residual(14) = params(4)*exp(y(24)*(params(4)-1))*T(27)*y(65)+y(64)+T(30)*y(19)*(-(exp(y(43))*(1-params(7))));
residual(15) = T(8)*y(73)+y(56)*(-(params(11)*T(12)*T(45)))+y(55)*(-(params(11)*T(46)*T(47)));
residual(16) = y(60)*(-exp(y(37)))+y(58)*(-(T(5)*T(19)*T(16)*T(49)))+y(57)*(-(T(17)*T(3)*T(16)*T(50)))+y(56)*(-(T(14)*params(11)*T(48)))+exp(y(37))*y(55)+params(21)*y(117)-y(82);
residual(17) = T(20)*y(60)+params(21)*y(98)*(-(T(57)*T(60)))+params(21)*y(99)*(-(T(61)*(T(53)*T(63)*T(64)+T(54)*T(63)*T(66))))+params(21)*y(100)*T(70)+params(21)*y(101)*(-(exp((1-params(3))*y(92))*exp(T(1)*y(96))*params(3)*exp(params(3)*y(38))))+params(21)*y(102)*(-(T(20)*(1-params(10))));
residual(18) = (T(33)-exp(y(23)))*T(74)+y(62)*(-(params(1)*T(74)/T(26)))+T(4)*y(61)+y(59)*T(76)+y(58)*T(80)+y(57)*T(82)+y(55)*(-(T(47)*T(84)))+params(21)*y(103)*(-((-(T(74)*T(86)))/(T(24)*T(24))));
residual(19) = (T(33)-exp(y(23)))*T(87)+y(62)*T(88)+exp(y(40))*y(60)+params(21)*y(103)*(-((-(T(86)*T(87)))/(T(24)*T(24))));
residual(20) = exp(y(41))*y(58)+T(89);
residual(21) = y(61)*(-(T(21)*T(90)))+exp(y(42))*y(57);
residual(22) = T(91);
residual(23) = y(75)+params(21)*y(110)*(-params(15))+y(59)*(-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))))+y(58)*(-(T(5)*T(19)*T(16)*T(92)))+y(57)*(-(T(17)*T(3)*T(16)*T(93)))+y(55)*(-(T(47)*T(95)))+T(96)*(-params(16))*y(120);
residual(24) = T(99)+y(74)+T(103);
residual(25) = y(77);
residual(26) = y(78);
residual(27) = y(79);
residual(28) = y(80);
residual(29) = y(81);
residual(30) = y(82);
residual(31) = T(24)*T(104)+exp(y(52))*y(76);
residual(32) = y(84);
residual(33) = y(83);
residual(34) = exp(y(37))-T(9)^T(10);
residual(35) = exp(y(22))-params(11)*T(12)*T(14);
residual(36) = exp(y(42))-T(3)*T(15)*T(16)*T(17);
residual(37) = exp(y(41))-T(5)*T(16)*T(18)*T(19);
residual(38) = exp(y(33))-exp(T(1)*y(44))*exp(y(13)*params(3))*exp(y(39)*(1-params(3)));
residual(39) = exp(y(40))+T(20)+exp(y(24))+exp(y(23))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(6)*exp(params(5)*(y(10)-y(45)))*exp(y(6))-(exp(y(37))+exp(y(13))*(1-params(10)));
residual(40) = T(4)-T(21)*exp(y(42))^T(22);
residual(41) = 1-exp(y(95))*(1+exp(y(94))-params(10));
residual(42) = exp(y(43))-params(1)*T(24)/T(26);
residual(43) = y(34)-exp(y(95))*(exp(y(32))*exp(y(87))+(1-exp(y(32)))*y(88)-params(6)*exp(params(5)*y(32)));
residual(44) = y(35)-(y(34)*params(7)+exp(y(95))*(1-params(7))*y(89));
residual(45) = y(35)*params(4)*exp(y(24)*(params(4)-1))*T(27)-1;
residual(46) = T(105);
residual(47) = exp(y(28))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(30)));
residual(48) = exp(y(27))-(exp(y(6))*(1-exp((-y(45)))*exp(y(10)))+params(7)*exp(y(29)));
residual(49) = exp(y(30))-((1-params(7))*exp(y(9))+T(27)*exp(y(24)*params(4)));
residual(50) = exp(y(29))-((1-params(7))*exp(y(8))+exp(y(23)*params(4))*T(28));
residual(51) = exp(y(26))-exp(y(7))*exp(y(11));
residual(52) = exp(y(25))-exp(y(6))*exp((-y(45)))*exp(y(10));
residual(53) = T(8)-(exp(y(26))+exp(y(25)));
residual(54) = y(45)-x(it_, 1);
residual(55) = y(44)-(x(it_, 2)+params(15)*y(16)+params(16)*y(21));
residual(56) = exp(y(52))-exp(y(10));
residual(57) = y(46)-(y(22)-y(1));
residual(58) = y(47)-(y(24)-y(3));
residual(59) = y(48)-(y(23)-y(2));
residual(60) = y(49)-(y(26)-y(5));
residual(61) = y(50)-(y(25)-y(4));
residual(62) = y(51)-(y(37)-y(12));
residual(63) = y(54)-(y(28)-y(7));
residual(64) = y(53)-(y(27)-y(6));
lhs = y(85);
rhs = y(110);
residual(65) = lhs - rhs;
lhs = y(86);
rhs = y(16);
residual(66) = lhs - rhs;

end
